﻿//|---------------------------------------------------------------|
//|                         SORT DEMO                             |
//|                    Developed by Wonde Tadesse                 |  
//|                             Copyright ©  2011                 |
//|---------------------------------------------------------------|
//|                         SORT DEMO                             |
//|---------------------------------------------------------------|
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Data.Common;
using System.Web.UI.WebControls;
using SortLibray;

namespace SortDemo
{
    /// <summary>
    /// SortExtension class
    /// </summary>
    public static class SortExtension
    {
        /// <summary>
        /// List Sort extension method
        /// </summary>
        /// <typeparam name="T">Type T to be sorted</typeparam>
        /// <param name="genericList">Generic list to be sorted</param>
        /// <param name="sortDirection">SortDirection value</param>
        /// <param name="comparer">Comparer value</param>
        /// <param name="caseSensitive">CaseSensitive indicator value</param>
        /// <returns>Sorted list of type T</returns>
        public static IList<T> SortedList<T>(this List<T> genericList,
            string sortExpression, SortDirection sortDirection,
            CharacterComparer<T> comparer = null, bool caseSensitive = false)
        {
            if (genericList == null ||
                string.IsNullOrEmpty(sortExpression) ||
                string.IsNullOrWhiteSpace(sortExpression))
                return null;
            else
            {
                if (comparer == null)
                    if (caseSensitive)
                        comparer = new CharacterComparer<T>(sortExpression, caseSensitive);
                    else
                        comparer = new CharacterComparer<T>(sortExpression);
                else
                    if (caseSensitive)
                        if (!comparer.CaseSensitive)
                            comparer.CaseSensitive = caseSensitive;

                genericList.Sort(comparer);
                if (sortDirection == SortDirection.Descending)
                    genericList.Reverse();
            }
            return genericList;
        }

        /// <summary>
        /// List Sort extension method
        /// </summary>
        /// <typeparam name="T">Type T to be sorted</typeparam>
        /// <param name="genericList">Generic list to be sorted</param>
        /// <param name="sortDirection">SortDirection value</param>
        /// <param name="comparer">Comparer value</param>
        /// <param name="caseSensitive">CaseSensitive indicator value</param>
        /// <returns>Sorted list of type T</returns>
        public static IList<T> SortedList<T>(this List<T> genericList, SortDirection sortDirection,
            CharacterComparer<T> comparer, bool caseSensitive = false)
        {
            if (caseSensitive)
                if (!comparer.CaseSensitive)
                    comparer.CaseSensitive = caseSensitive;

            genericList.Sort(comparer);
            if (sortDirection == SortDirection.Descending)
                genericList.Reverse();
            return genericList;
        }

        /// <summary>
        /// List Sort extension method
        /// </summary>
        /// <typeparam name="T">Type T to be sorted</typeparam>
        /// <param name="genericList">Generic list to be sorted</param>
        /// <param name="sortExpression">SortExpression value</param>
        /// <param name="sortDirection">SortDirection value</param>
        /// <param name="caseSensitive">CaseSensitive indicator value</param>
        /// <returns>Sorted list of type T</returns>
        public static IList<T> SortedList<T>(this List<T> genericList, string sortExpression, SortDirection sortDirection,
            bool caseSensitive = false)
        {
            return SortedList(genericList, sortExpression, sortDirection, null, caseSensitive);
        }               
    }
}